<?php

namespace App\Providers;

use App\Models\Business;
use App\Models\Session;
use App\Models\User;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Boot the authentication services for the application.
     *
     * @return void
     */
    public function boot()
    {
        // Here you may define how you wish users to be authenticated for your Lumen
        // application. The callback which receives the incoming request instance
        // should return either a User instance or null. You're free to obtain
        // the User instance via an API token or any other method necessary.

        $this->app['auth']->viaRequest('api', function ($request) {
            // if ($request->input('api_token')) {
            //     return User::where('api_token', $request->input('api_token'))->first();
            // }

            // if ($request->header('Authorization')) {
            //     $user = User::where('token', $request->header('Authorization'))->first();
            //     if($user) {
            //         return User::where('id', $user->id)->first();
            //     }
            //     return User::where('token', $request->header('Authorization'))->first();
            // }
            // if ($request->header('Authorization')) {
            //     $user = User::where('token', $request->header('Authorization'))->first();
            //     if($user) {
            //         return User::where('objectId', $user->objectId)->where('isDeleted', false)->first();
            //     }
            //     return User::where('token', $request->header('Authorization'))->where('isDeleted', false)->first();
            // }
            // if ($request->header('Authorization')) {
            //     $user = User::where('token', $request->header('Authorization'))->first();
            //     if($user) {
            //         return User::where('objectId', $user->objectId)->first();
            //     }
            //     return User::where('token', $request->header('Authorization'))->first();
            // }
            if ($request->header('Authorization')) {
                $session = Session::where([
                    ['token', $request->header('Authorization')]
                ])->first();

                if (!$session) return null;

                $user = $session->user;
                $user = $user
                    ? User::where('isDeleted', false)->find($user->objectId)
                    : null;

                if ($request->is('adminUser/*') || $request->is('unsubscribed/adminUser/*')) {
                    return $user->admin;
                } else if ($request->is('superAdminUser/*')) {
                    return $user->superAdmin;
                } else if ($request->is('tattooArtistUser/*')) {
                    return $user->tattooArtist;
                }
                return $user;
            }
        });
    }
}
