<?php

namespace App\Traits;

use Illuminate\Support\Facades\Storage;

trait FilesTrait
{
    public function fileName($file, $name)
    {
        $extension = $file->getClientOriginalExtension();
        return "$name.$extension";
    }

    static public function pathName($url)
    {
        $urlParts = explode('/', $url);
        return $urlParts[sizeof($urlParts) - 1];
    }
    static public function createFile($path, $nameFile, $id, $file)
    {
        $pathFull = "$path/$id/$nameFile/";
        $timeStamp = time();
        $extension = $file->getClientOriginalExtension();
        $extension = !!$extension ? $extension : 'png';
        $name = $nameFile . "_" . $timeStamp . "." . $extension;

        if (Storage::disk('public')->exists($pathFull)) {
            Storage::disk('public')->deleteDirectory($pathFull);
        }
        if (Storage::disk('public')->putFileAs("/$pathFull", $file, $name)) {
            return $pathFull . $name;
        }
        return null;
    }

    static public function deleteDirectory($path, $id)
    {
        $fullPath = "$path/$id";

        if (Storage::disk('public')->exists($fullPath)) {
            Storage::disk('public')->deleteDirectory($fullPath);
        }
    }

    static public function moveFile($pathFull, $url_file, $newPath)
    {
        if (Storage::disk('public')->exists($pathFull))
            Storage::deleteDirectory($pathFull);
        if (Storage::disk('public')->copy($url_file, $newPath))
            return true;
        return false;
    }
}
