<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBusinessesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('businesses', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->string('name');

            // Address
            $table->text('address');
            $table->string('state')->nullable();
            $table->string('city')->nullable();

            $table->string('phone');
            $table->text('website')->nullable();
            $table->string('email');
            $table->text('logo')->nullable();
            $table->string('legend')->nullable();
            $table->boolean('sendTicket')->nullable()->default(true);

            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('businesses');
    }
}
