<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudiosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('studios', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->string('name');

            // Address
            $table->text('address');
            $table->string('state')->nullable();
            $table->string('city')->nullable();

            $table->string('phone');
            $table->text('website')->nullable();
            $table->string('email');
            $table->text('logo')->nullable();
            $table->string('legend')->nullable();

            $table->uuid('businessObjectId');
            $table->foreign('businessObjectId')->references('objectId')->on('businesses');

            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('studios');
    }
}
