<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTattooArtistsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tattoo_artists', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            // $table->float('salePercentage');
            $table->decimal('salePercentage', 5, 4);

            $table->uuid('studioObjectId');
            $table->foreign('studioObjectId')->references('objectId')->on('studios');

            $table->uuid('userObjectId');
            $table->foreign('userObjectId')->references('objectId')->on('users');

            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tattoo_artists');
    }
}
