<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdminsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');

            $table->string('customerId', 100)->unique()->nullable();
            $table->date('startDate')->nullable();
            $table->date('endDate')->nullable();
            $table->date('deleteDate')->nullable();
            $table->boolean('deleteEmailSent')->default(false);
            $table->boolean('subscriptionAlertSent')->default(false);
            $table->boolean('isDisabled')->default(false);

            $table->uuid('businessObjectId');
            $table->foreign('businessObjectId')->references('objectId')->on('businesses');

            $table->uuid('planObjectId')->nullable();
            $table->foreign('planObjectId')->references('objectId')->on('plans');

            $table->uuid('userObjectId');
            $table->foreign('userObjectId')->references('objectId')->on('users');

            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admins');
    }
}
