<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->decimal('salePercentage', 5, 4);
            $table->string('clientName');
            $table->string('clientEmail')->nullable();
            $table->float('advance')->nullable();

            $table->uuid('paymentMethodObjectId');
            $table->foreign('paymentMethodObjectId')->references('objectId')->on('payment_methods');
            $table->string('otherPaymentMethod')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales');
    }
}
