<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOperationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('operations', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->float('amount')->default(0);
            $table->string('concept')->nullable();
            $table->dateTime('date');

            $table->uuid('studioObjectId');
            $table->foreign('studioObjectId')->references('objectId')->on('studios');

            $table->uuid('tattooArtistObjectId');
            $table->foreign('tattooArtistObjectId')->references('objectId')->on('tattoo_artists');

            $table->uuid('saleObjectId')->nullable();
            $table->foreign('saleObjectId')->references('objectId')->on('sales');

            $table->uuid('advancePaymentObjectId')->nullable();
            $table->foreign('advancePaymentObjectId')->references('objectId')->on('advance_payments');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('operations');
    }
}
