<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');

            $table->date('startDate');
            $table->date('endDate');
            
            $table->uuid('tattooArtistObjectId');
            $table->foreign('tattooArtistObjectId')->references('objectId')->on('tattoo_artists');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
