<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRecurringChargesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recurring_charges', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->integer('periodicity');
            $table->integer('day');
            $table->float('amount')->default(0);
            $table->string('concept')->nullable();
            $table->uuid('tattooArtistObjectId');
            $table->foreign('tattooArtistObjectId')->references('objectId')->on('tattoo_artists');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recurring_charges');
    }
}
