<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDefaultQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('default_questions', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->integer('questionNumber');
            $table->string('question');
            $table->json('options')->nullable();
            $table->string('type');
            $table->boolean('required');
            $table->boolean('alwaysRequired');
            $table->boolean('isDefault')->default(true);
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('default_questions');
    }
}
