<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->integer('questionNumber');
            $table->string('question');
            $table->text('description')->nullable();
            $table->json('options')->nullable();
            $table->string('type');
            $table->boolean('required');
            $table->uuid('formObjectId');
            $table->foreign('formObjectId')
                ->references('objectId')
                ->on('forms');
            $table->uuid('defaultQuestionObjectId')->nullable();
            $table->foreign('defaultQuestionObjectId')
                ->references('objectId')
                ->on('default_questions');
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('questions');
    }
}
