<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFormResponsesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('form_responses', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->text('signature')->nullable();
            $table->uuid('formObjectId');
            $table->foreign('formObjectId')
                ->references('objectId')
                ->on('forms');
            $table->uuid('studioObjectId');
            $table->foreign('studioObjectId')
                ->references('objectId')
                ->on('studios');
            // $table->boolean('finished')->default(false);
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('form_responses');
    }
}
