<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateResponsesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('responses', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->integer('questionNumber');
            $table->string('question');
            $table->json('data')->nullable();
            $table->string('type');
            $table->boolean('required');
            $table->uuid('formResponseObjectId');
            $table->foreign('formResponseObjectId')
                ->references('objectId')
                ->on('form_responses');
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('responses');
    }
}
