<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->string('name');
            $table->float('price')->nullable();
            $table->text('description')->nullable();
            $table->uuid('businessObjectId');
            $table->foreign('businessObjectId')
                ->references('objectId')
                ->on('businesses');
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
