<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductPurchasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_purchases', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->string('clientName');
            $table->string('clientEmail')->nullable();
            $table->string('paymentMethod');
            // $table->string('name');
            // $table->float('price')->nullable();
            // $table->text('description')->nullable();
            $table->uuid('saleObjectId')->nullable();
            // $table->foreign('saleObjectId')
            //     ->references('objectId')
            //     ->on('sales');
            $table->uuid('businessObjectId');
            $table->foreign('businessObjectId')
                ->references('objectId')
                ->on('businesses');
            $table->uuid('tattooArtistObjectId');
            $table->foreign('tattooArtistObjectId')
                ->references('objectId')
                ->on('tattoo_artists');
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_purchases');
    }
}
