<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductPurchaseItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_purchase_items', function (Blueprint $table) {
            $table->uuid('objectId');
            $table->primary('objectId');
            $table->string('name');
            $table->float('price')->nullable();
            $table->integer('quantity');
            $table->text('description')->nullable();
            $table->uuid('productPurchaseObjectId');
            $table->foreign('productPurchaseObjectId')
                ->references('objectId')
                ->on('product_purchases');
            $table->uuid('productObjectId');
            $table->foreign('productObjectId')
                ->references('objectId')
                ->on('products');
            $table->boolean('isCancelled')->default(false);
            $table->boolean('isDeleted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_purchase_items');
    }
}
