<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Business;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        $user = User::create([
            'name' => 'admin',
            'email' => 'admin@mail.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $business = Business::first();

        $admin = Admin::create([
            'businessObjectId' => $business->objectId,
            'userObjectId' => $user->objectId
        ]);
    }
}
