<?php

namespace Database\Seeders;

use App\Models\AdvancePayment;
use App\Models\Operation;
use App\Models\Studio;
use App\Models\TattooArtist;
use Illuminate\Database\Seeder;

class AdvancePaymentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tattooArtists = TattooArtist::all();

        foreach ($tattooArtists as $tattooArtist) {
            $studio = $tattooArtist->studio;
    
            $allAdvancePayments = [];
            $allAdvancePayments[] = AdvancePayment::create([]);
            $allAdvancePayments[] = AdvancePayment::create([]);
            $allAdvancePayments[] = AdvancePayment::create([]);
    
            Operation::create([
                'amount' => 100,
                'concept' => 'tinta',
                'date' => date('Y-m-d H:i:s', strtotime('now')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'advancePaymentObjectId' => $allAdvancePayments[0]->objectId
            ]);
            Operation::create([
                'amount' => 399,
                'concept' => 'seguro',
                'date' => date('Y-m-d H:i:s', strtotime('now + 1 days')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'advancePaymentObjectId' => $allAdvancePayments[1]->objectId
            ]);
            Operation::create([
                'amount' => 200,
                'concept' => 'adelanto',
                'date' => date('Y-m-d H:i:s', strtotime('now + 2 days')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'advancePaymentObjectId' => $allAdvancePayments[2]->objectId
            ]);    
        }
    }
}
