<?php

namespace Database\Seeders;

use App\Models\DefaultQuestion;
use Illuminate\Database\Seeder;

class DefaultQuestionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // DefaultQuestion::create([
        //     'questionNumber' => 0,
        //     'question' => 'Términos y condiciones',
        //     'type' => 'checkbox',
        //     'options' => [
        //         'Acepto los términos y condiciones'
        //     ],
        //     'required' => true,
        //     'alwaysRequired' => true,
        // ]);

        DefaultQuestion::create([
            'questionNumber' => 1,
            'question' => 'Nombre',
            'type' => 'text',
            'required' => true,
            'alwaysRequired' => true,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 2,
            'question' => 'Dirección',
            'type' => 'text',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 3,
            'question' => 'Teléfono celular',
            'type' => 'number',
            'required' => true,
            'alwaysRequired' => true,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 4,
            'question' => 'Fecha de nacimiento',
            'type' => 'date',
            'required' => true,
            'alwaysRequired' => false,
        ]);

        // DefaultQuestion::create([
        //     'questionNumber' => 4,
        //     'question' => 'Tu tatuador',
        //     'options' => [],
        //     'type' => 'select',
        //     'required' => true,
        //     'alwaysRequired' => false,
        // ]);

        DefaultQuestion::create([
            'questionNumber' => 5,
            'question' => 'Email',
            'type' => 'text',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 6,
            'question' => 'Indica si padeces alguna de las siguientes enfermedades',
            'options' => [
                'Hemofilia',
                'Diabetes',
                'Epilepsia',
                'Hepatitis',
                'VIH',
                'Hipertensión',
                'Cardiopatía',
                'Otro',
                'Ninguno'
            ],
            'type' => 'checkbox',
            'required' => true,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 7,
            'question' => '¿Estás tomando algún medicamento?',
            'options' => [
                'Sí',
                'No',
            ],
            'type' => 'radio',
            'required' => true,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 8,
            'question' => '¿Cuál?',
            'type' => 'text',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 9,
            'question' => '¿Eres alérgico a algún medicamento?',
            'options' => [
                'Sí',
                'No'
            ],
            'type' => 'radio',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 10,
            'question' => '¿Cuál?',
            'type' => 'text',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 11,
            'question' => '¿Tuviste alguna infección los últimos 5 días?',
            'options' => [
                'Sí',
                'No'
            ],
            'type' => 'radio',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 12,
            'question' => '¿Te indicaron algún medicamento?',
            'options' => [
                'Sí',
                'No'
            ],
            'type' => 'radio',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 13,
            'question' => '¿Cuál?',
            'type' => 'text',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 14,
            'question' => '¿Estás embarazada?',
            'options' => [
                'Sí',
                'No'
            ],
            'type' => 'radio',
            'required' => false,
            'alwaysRequired' => false,
        ]);

        DefaultQuestion::create([
            'questionNumber' => 15,
            'question' => 'Tu tatuador',
            'options' => [],
            'type' => 'tattooArtist',
            'required' => true,
            'alwaysRequired' => false,
        ]);
    }
}
