<?php

namespace Database\Seeders;

use App\Custom\PeriodicityCustom;
use App\Models\RecurringCharge;
use App\Models\TattooArtist;
use Illuminate\Database\Seeder;

class RecurringChargeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tattooArtists = TattooArtist::all();
        
        foreach($tattooArtists as $tattooArtist) {
            RecurringCharge::create([
                'periodicity' => PeriodicityCustom::MONTHLY,
                'day' => 20,
                'amount' => 300,
                'concept' => 'Seguro',
                'tattooArtistObjectId' => $tattooArtist->objectId
            ]);
            RecurringCharge::create([
                'periodicity' => PeriodicityCustom::WEEKLY,
                'day' => 2,
                'amount' => 50,
                'concept' => 'Estacionamiento',
                'tattooArtistObjectId' => $tattooArtist->objectId
            ]);
        }
        
    }
}
