<?php

namespace Database\Seeders;

use App\Models\Operation;
use App\Models\PaymentMethod;
use App\Models\Sale;
use App\Models\Studio;
use App\Models\TattooArtist;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class SaleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tattooArtists = TattooArtist::all();
        foreach ($tattooArtists as $tattooArtist) {
            $studio = $tattooArtist->studio;
            $paymentMethod = PaymentMethod::first();
    
            $allSales = [];
            $allSales[] = Sale::create([
                'salePercentage' => 0.6,
                'paymentMethodObjectId' => $paymentMethod->objectId,
                'clientName' => 'Cliente 1',
                'advance' => 100,
                'clientEmail' => 'cliente1@mail.com',
            ]);
            $allSales[] = Sale::create([
                'salePercentage' => 0.5,
                'paymentMethodObjectId' => $paymentMethod->objectId,
                'clientName' => 'Cliente 1',
                'advance' => 200,
                'clientEmail' => 'cliente1@mail.com',
            ]);
            $allSales[] = Sale::create([
                'salePercentage' => 0.7,
                'paymentMethodObjectId' => $paymentMethod->objectId,
                'clientName' => 'Cliente 1',
                'clientEmail' => 'cliente1@mail.com',
            ]);
    
            Operation::create([
                'amount' => 900,
                'concept' => 'tatuaje unicornio',
                'date' => date('Y-m-d H:i:s', strtotime('now')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'saleObjectId' => $allSales[0]->objectId
            ]);
            Operation::create([
                'amount' => 1000,
                'concept' => 'tatuaje corazón',
                'date' => date('Y-m-d H:i:s', strtotime('now + 1 days')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'saleObjectId' => $allSales[1]->objectId
            ]);
            Operation::create([
                'amount' => 1200,
                'concept' => 'tatuaje nombre',
                'date' => date('Y-m-d H:i:s', strtotime('now + 2 days')),
                'tattooArtistObjectId' => $tattooArtist->objectId,
                'studioObjectId' => $studio->objectId,
                'saleObjectId' => $allSales[2]->objectId
            ]);
        }
    }
}
