<?php

namespace Database\Seeders;

use App\Models\Studio;
use App\Models\TattooArtist;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class TattooArtistSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $studios = Studio::all();
        $studio = $studios[0];
        $studio2 = $studios[1];

        // tatuador 1-1
        $user = User::create([
            'name' => 'tattoo 1-1',
            'email' => 'tattoo1_1@mail.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio2->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.5
        ]);
        // tatuador 2-1
        $user = User::create([
            'name' => 'tattoo 2-1',
            'email' => 'tattoo2_1@mail.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio2->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.5
        ]);

        // tatuador 1
        $user = User::create([
            'name' => 'tattoo 1',
            'email' => 'tattoo1@mail.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.6
        ]);

        // tatuador 2
        $user = User::create([
            'name' => 'tattoo 2',
            'email' => 'tattoo2@mail.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.6
        ]);

        // tatuador 3
        $user = User::create([
            'name' => 'elber',
            'email' => 'enrique5001@hotmail.com',
            'password' => Hash::make('12345'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.6
        ]);

        // tatuador 4
        $user = User::create([
            'name' => 'raúl',
            'email' => 'raul.hernandez@iknesoft.com',
            'password' => Hash::make('123123123'),
            'photo' => null
        ]);

        $tattooArtist = TattooArtist::create([
            'studioObjectId' => $studio->objectId,
            'userObjectId' => $user->objectId,
            'salePercentage' => 0.6
        ]);
    }
}
