<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    @php
        $headerHeight = 80;
        $marginLeftPx = 40;
        $marginRightPx = 40;

        $marginTopPx = $headerHeight + $marginLeftPx * 2;
        $marginBottomPx = $headerHeight + $marginLeftPx * 2;

        $marginTop = $marginTopPx . 'px';
        $marginBottom = $marginBottomPx . 'px';
        $marginLeft = $marginLeftPx . 'px';
        $marginRight = $marginRightPx . 'px';

        $pageMargins = "$marginTop $marginRight $marginBottom $marginLeft";

        function publicPath($filePath) {
            $basePath = rtrim(app()->basePath('public'), '/');
            $trimmedFilePath = ltrim($filePath, '/');
            $path = "$basePath/$trimmedFilePath";
            // return Storage::exists($path) ? $path : '';
            return $path;
        }

        $logo = $form->business->logo
            ? $form->business->logo
            : "resources/logo-alt.png";
    @endphp
    <link rel="stylesheet" href="{{ publicPath('/css/app.css') }}" />
    <style>
        body { margin: {{ $pageMargins }}; }
        .header { height: {{ $marginTop }}; }
        .footer { height: {{ $marginBottom }}; }
        .fullcenter {
            transform: translate(-50%, -50%);
            position: absolute;
            left: 50%;
            top: 50%;
        }
        .x-center {
            position: relative;
            left: 50%;
            transform: translateX(-50%);
        }
    </style>
</head>
<body>
    <header class="header w-full">

        <table cellspacing="0" cellpadding="0" class="border-none w-full" style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <tr class="h-full">
                <td valign="middle" style="width: 200px;">
                    <div style="height: {{ $headerHeight }}px; width: 200px; background-image: url({{ publicPath("/uploads/$logo") }}); background-repeat: no-repeat; background-size: contain;"></div>
                </td>
                <td valign="middle" class="text-right">
                    <span class="font-normal text-2xl-alt text-secondary-dark">{{ $form->business->name }}</span>
                    <br>
                    <span class="font-light text-secondary-dark text-base-alt">
                        Formulario
                        {{-- <span class="font-light text-tertiary-dark text-base-alt">
                            {{ date('d/m/Y') }}
                        </span> --}}
                    </span>
                </td>
            </tr>
        </table>
    </header>
    {{-- <footer class="footer bg-secondary-dark text-primary text-center">
        <div style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <table class="h-full w-full table-fixed">
                <tr>
                    <td valign="middle">
                        @if($business->name)
                        <div class="text-base p-0 m-0">
                            {{ $business->name }}
                        </div>
                        @endif
                        @if($legend)
                        <div class="text-base p-0 m-0">
                            {{ $legend }}
                        </div>
                        @endif
                    </td>
                    <td valign="middle" class="text-right">
                        @if($website)
                        <div class="text-base p-0 m-0">
                            <a
                                href="https://{{ $website }}"
                                target="_blank"
                                class="text-primary text-decoration-none font-light"
                            >
                                {{ $website }}
                            </a>
                        </div>
                        @endif
                        @if($email)
                        <div class="text-base p-0 m-0">
                            {{ $email }}
                        </div>
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </footer> --}}

    <p class="font-light text-center">Para responder el formulario escanea el siguiente código:</p>
    <img src="data:image/png;base64, {!! $qrcode !!}" class="x-center">
    <p class="font-light text-center mt-4">También puedes ingresar directamente a la URL:</p>
    <p class="font-normal text-center break-words">{{ "$form->response_url/$studio/responder" }}</p>
</body>
</html>
