<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Reporte de corte</title>
    @php
        $headerHeight = 80;
        $marginLeftPx = 40;
        $marginRightPx = 40;

        $marginTopPx = $headerHeight + $marginLeftPx * 2;
        $marginBottomPx = $headerHeight + $marginLeftPx * 2;

        $marginTop = $marginTopPx . 'px';
        $marginBottom = $marginBottomPx . 'px';
        $marginLeft = $marginLeftPx . 'px';
        $marginRight = $marginRightPx . 'px';

        $pageMargins = "$marginTop $marginRight $marginBottom $marginLeft";

        function publicPath($filePath) {
            $basePath = rtrim(app()->basePath('public'), '/');
            $trimmedFilePath = ltrim($filePath, '/');
            $path = "$basePath/$trimmedFilePath";
            // return Storage::exists($path) ? $path : '';
            return $path;
        }

        function formatAmount($amount) {
            return $amount
                ? '$ ' . number_format($amount, 2)
                : 'NA';
        }

        $tattooArtist = $payroll->tattooArtist;
        $studio = $tattooArtist ? $tattooArtist->studio : null;
        $business = $studio ? $studio->business : null;

        function getField($field, $payroll, $default = null) {
            $tattooArtist = $payroll->tattooArtist;
            $studio = $tattooArtist ? $tattooArtist->studio : null;
            $business = $studio ? $studio->business : null;
            $value = $default;

            if ($business[$field]) {
                $value = $business[$field];
            }
            if ($studio[$field]) {
                $value = $studio[$field];
            }

            return $value;
        }

        $logo = getField('logo', $payroll, '/resources/logo-alt.png');
        $legend = getField('legend', $payroll);
        $website = getField('website', $payroll);
        $email = getField('email', $payroll);
        $name = getField('name', $payroll);
    @endphp
    <link rel="stylesheet" href="{{ publicPath('/css/app.css') }}" />
    <style>
        body {
            margin: {{ $pageMargins }};
        }

        .header {
            height: {{ $marginTop }};
        }

        .footer {
            height: {{ $marginBottom }};
        }

        .table-border {
            border-top: 1px solid #2a2a2a;
        }
        .table-border:last-child td {
            border-bottom: 1px solid #2a2a2a;
        }

        .table-border td + td {
            border-left: 1px solid #2a2a2a;
        }
    </style>
</head>

<body>

    <header class="header w-full">
        {{-- <div class="bg-rose-200 relative" style="height: {{ $headerHeight }}px; margin-top: {{ $marginTopPx - $headerHeight }}px; margin-left: {{ $marginLeft }}; margin-right: {{ $marginRight }}">
            <span style="line-height: 100px;" class="absolute inset-y-0 align-middle right-0 bg-rose-400">Ticket de venta</span>
        </div> --}}

        <table cellspacing="0" cellpadding="0" class="border-none w-full" style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <tr class="h-full">
                <td valign="middle" style="width: 200px;">
                    {{-- <div style="height: {{ $headerHeight }}px; width: 200px; background-image: url(https://upload.wikimedia.org/wikipedia/commons/4/47/PNG_transparency_demonstration_1.png); background-repeat: no-repeat; background-size: contain;"></div> --}}
                    <div style="height: {{ $headerHeight }}px; width: 200px; background-image: url({{ publicPath("/uploads/$logo") }}); background-repeat: no-repeat; background-size: contain;"></div>
                </td>
                <td valign="middle" class="text-right">
                    <span class="font-normal text-2xl-alt text-secondary-dark">Reporte de corte</span>
                    <br>
                    <span class="font-normal text-secondary-dark text-base-alt">
                        Fecha:
                        <span class="font-light text-tertiary-dark text-base-alt">
                            {{ date('d/m/Y', strtotime($payroll->startDate)) }} a {{ date('d/m/Y', strtotime($payroll->endDate)) }}
                        </span>
                    </span>
                </td>
            </tr>
        </table>
    </header>
    <footer class="footer bg-secondary-dark text-primary text-center">
        <div style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <table class="h-full w-full table-fixed">
                <tr>
                    <td valign="middle">
                        @if($business->name)
                        <div class="text-base p-0 m-0">
                            {{ $business->name }}
                        </div>
                        @endif
                        @if($legend)
                        <div class="text-base p-0 m-0">
                            {{ $legend }}
                        </div>
                        @endif
                    </td>
                    <td valign="middle" class="text-right">
                        @if($website)
                        <div class="text-base p-0 m-0">
                            <a
                                href="https://{{ $website }}"
                                target="_blank"
                                class="text-primary text-decoration-none font-light"
                            >
                                {{ $website }}
                            </a>
                        </div>
                        @endif
                        @if($email)
                        <div class="text-base p-0 m-0">
                            {{ $email }}
                        </div>
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </footer>

    <div>
        <h1 class="text-2xl-alt my-0 font-normal">
            Tatuador:
            <span class="font-light text-tertiary-dark">
                {{ $payroll->tattooArtist->user->name }}
            </span>
        </h1>
        <h2 class="text-base-alt my-0 mb-4 font-normal">
            Estudio:
            <span class="font-light text-tertiary-dark">
                {{ $studio->name }}
            </span>
        </h2>

        <table class="w-full border-collapse table-fixed">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap">Ingreso bruto</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Anticipos</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Ingreso tienda</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Ingreso tatuador</td>
            </tr>

            <tr class="table-border text-tertiary-dark text-xs">
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($summary['grossIncome']) }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($summary['advances']) }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($summary['studioIncome']) }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($summary['tattooArtistIncome']) }}
                </td>
            </tr>
        </table>

        <table class="w-full border-collapse pt-8 max-w-full table-fixed">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap" style="width: 20px;">Fecha</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Cliente</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Medio</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Concepto</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Anticipo</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Pago</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Tienda</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Tatuador</td>
            </tr>
            @foreach($operations as $date => $dateOperations)
                @foreach($dateOperations as $res)
                    @if($res->sale)
                        <tr class="table-border text-tertiary-dark text-xs">
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ date('d/m', strtotime($date)) }}
                            </td>
                            <td class="p-1 table-border font-light break-words">
                                {{ $res->sale->clientName ?? 'NA'}}
                            </td>
                            <td class="p-1 table-border font-light break-words">
                                @if ($res->sale->paymentMethod->type == 'Otro')
                                    {{ $res->sale->otherPaymentMethod ?? $res->sale->paymentMethod->type}}
                                @else
                                    {{ $res->sale->paymentMethod->type ?? 'NA'}}
                                @endif
                            </td>
                            <td class="p-1 table-border font-light break-words">
                                {{ $res->concept ?? 'NA'}}
                            </td>
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ formatAmount($res->sale->advance) }}
                            </td>
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ formatAmount($res->amount) }}
                            </td>
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ formatAmount($res->amount * (1 - $res->sale->salePercentage)) }}
                            </td>
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ formatAmount($res->amount * $res->sale->salePercentage) }}
                            </td>
                        </tr>
                    @endif
                @endforeach
            @endforeach
        </table>

        <table class="border-collapse pt-8" align="right">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap">Fecha</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Cobrado</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Observaciones</td>
            </tr>

            @foreach($operations as $date => $dateOperations)
                @foreach($dateOperations as $res)
                    @if($res->advancePayment)
                        <tr class="table-border text-tertiary-dark text-xs">

                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                {{ date('d/m', strtotime($res->date)) }}

                            </td>
                            <td class="p-1 table-border font-light whitespace-no-wrap">
                                -{{ formatAmount($res->amount) }}

                            </td>
                            <td class="p-1 table-border font-light max-w-full w-80">
                                {{ $res->concept ?? 'NA' }}
                            </td>
                        </tr>
                    @endif
                @endforeach
            @endforeach
        </table>
    </div>
</body>

</html>
