<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket de venta</title>
    @php
        $headerHeight = 80;
        $marginLeftPx = 40;
        $marginRightPx = 40;

        $marginTopPx = $headerHeight + $marginLeftPx * 2;
        $marginBottomPx = $headerHeight + $marginLeftPx * 2;

        $marginTop = $marginTopPx . 'px';
        $marginBottom = $marginBottomPx . 'px';
        $marginLeft = $marginLeftPx . 'px';
        $marginRight = $marginRightPx . 'px';

        $pageMargins = "$marginTop $marginRight $marginBottom $marginLeft";

        function publicPath($filePath) {
            $basePath = rtrim(app()->basePath('public'), '/');
            $trimmedFilePath = ltrim($filePath, '/');
            $path = "$basePath/$trimmedFilePath";
            // return Storage::exists($path) ? $path : '';
            return $path;
        }

        function formatAmount($amount) {
            return $amount
                ? '$ ' . number_format($amount, 2)
                : '$ 0.00';
        }

        $sale = $operation->sale;
        $tattooArtist = $operation->tattooArtist;
        $studio = $tattooArtist->studio;
        $business = $studio->business;

        function getField($field, $operation, $default = null) {
            $tattooArtist = $operation->tattooArtist;
            $studio = $tattooArtist->studio;
            $business = $studio->business;
            $value = $default;

            if ($business[$field]) {
                $value = $business[$field];
            }
            if ($studio[$field]) {
                $value = $studio[$field];
            }
            return $value;
        }

        $logo = getField('logo', $operation, '/resources/logo-alt.png');
        $legend = getField('legend', $operation);
        $website = getField('website', $operation);
        $email = getField('email', $operation);
        $name = getField('name', $operation);
    @endphp
    <link rel="stylesheet" href="{{ publicPath('/css/app.css') }}" />
    <style>
        body { margin: {{ $pageMargins }}; }
        .header { height: {{ $marginTop }}; }
        .footer { height: {{ $marginBottom }}; }
        .table-border-top {
            border-top: 1px solid #2a2a2a;
        }
        .table-border {
            border-top: 1px solid #2a2a2a;
        }
        .table-border:last-child td {
            border-bottom: 1px solid #2a2a2a;
        }

        .table-border td + td {
            border-left: 1px solid #2a2a2a;
        }
    </style>
</head>
<body>

    <header class="header w-full">
        {{-- <div class="bg-rose-200 relative" style="height: {{ $headerHeight }}px; margin-top: {{ $marginTopPx - $headerHeight }}px; margin-left: {{ $marginLeft }}; margin-right: {{ $marginRight }}">
            <span style="line-height: 100px;" class="absolute inset-y-0 align-middle right-0 bg-rose-400">Ticket de venta</span>
        </div> --}}

        <table cellspacing="0" cellpadding="0" class="border-none w-full" style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <tr class="h-full">
                <td valign="middle" style="width: 200px;">
                    <div style="height: {{ $headerHeight }}px; width: 200px; background-image: url({{ publicPath("/uploads/$logo") }}); background-repeat: no-repeat; background-size: contain;"></div>
                </td>
                <td valign="middle" class="text-right">
                    <span class="font-normal text-2xl-alt text-secondary-dark">Ticket de venta</span>
                    <br>
                    <span class="font-normal text-secondary-dark text-base-alt">
                        Fecha:
                        <span class="font-light text-tertiary-dark text-base-alt">
                            {{ date('d/m/Y', strtotime($operation->date)) }}
                        </span>
                    </span>
                </td>
            </tr>
        </table>
    </header>
    <footer class="footer bg-secondary-dark text-primary text-center">
        <div style="height: {{ $headerHeight }}px; margin-top: {{ $marginLeft }}px; padding-left: {{ $marginLeft }}; padding-right: {{ $marginRight }}">
            <table class="h-full w-full table-fixed">
                <tr>
                    <td valign="middle">
                        @if($business->name)
                        <div class="text-base p-0 m-0">
                            {{ $business->name }}
                        </div>
                        @endif
                        @if($legend)
                        <div class="text-base p-0 m-0">
                            {{ $legend }}
                        </div>
                        @endif
                    </td>
                    <td valign="middle" class="text-right">
                        @if($website)
                        <div class="text-base p-0 m-0">
                            <a
                                href="https://{{ $website }}"
                                target="_blank"
                                class="text-primary text-decoration-none font-light"
                            >
                                {{ $website }}
                            </a>
                        </div>
                        @endif
                        @if($email)
                        <div class="text-base p-0 m-0">
                            {{ $email }}
                        </div>
                        @endif
                    </td>
                </tr>
            </table>
        </div>
    </footer>

    <div class="text-secondary-dark">
        <div class="border-solid border-t-4 mb-4 border-0 border-secondary-dark"></div>
{{--
        <table class="table-fixed w-full border-none" cellspacing="0" cellpadding="0">
            <tr>
                <td class="align-top font-bold">Cliente</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">{{ $sale->clientName ?? 'NA' }}</td>
            </tr>
            <tr>
                <td class="align-top font-bold">Concepto</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">{{ $operation->concept ?? 'NA' }}</td>
            </tr>
            <tr>
                <td class="align-top font-bold">Tatuador</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">{{ $tattooArtist->user->name ?? 'NA' }}</td>
            </tr>
            <tr>
                <td class="align-top font-bold">Estudio</td>
                <td class="font-light text-tertiary-dark text-right">{{ $studio->name ?? 'NA' }}</td>
            </tr>

        </table>

        <div class="border-solid border-t-2 my-4 border-0 border-tertiary-light"></div>

        <table class="table-fixed w-full border-none" cellspacing="0" cellpadding="0">
            <tr>
                <td class="font-bold align-top">Método de pago</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">
                    @if ($sale->paymentMethod->type == 'Otro')
                        {{ $sale->otherPaymentMethod ?? $sale->paymentMethod->type}}
                    @else
                        {{ $sale->paymentMethod->type ?? 'NA'}}
                    @endif
                </td>
            </tr>
            <tr>
                <td class="font-bold align-top">Cotización</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">{{ formatAmount($operation->amount) }}</td>
            </tr>
            <tr>
                <td class="font-bold align-top">Anticipo</td>
                <td class="font-light text-tertiary-dark pb-4 text-right">{{ formatAmount($sale->advance) }}</td>
            </tr>
            <tr>
                <td class="font-bold align-top">Total</td>
                <td class="font-light text-tertiary-dark text-right">{{ formatAmount($operation->amount - $sale->advance) }}</td>
            </tr>
        </table> --}}

        {{--  Aquí empieza lo nuevo --}}

        <h3 class="font-bold">Tatuaje</h3>
        <table class="w-full border-collapse table-fixed">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap">Cliente</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Concepto</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Tatuador</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Estudio</td>
            </tr>
            <tr class="table-border text-tertiary-dark text-xs">
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ $sale->clientName ?? 'NA' }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ $operation->concept ?? 'NA' }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ $tattooArtist->user->name ?? 'NA' }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ $studio->name ?? 'NA' }}
                </td>
            </tr>
        </table>
        <div class="mt-8"></div>
        {{-- <div class="border-solid border-t-2 my-4 border-0 border-tertiary-light"></div> --}}
        <table class="w-full border-collapse table-fixed">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap">Método de pago</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Cotización</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Anticipo</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Total</td>
            </tr>
            <tr class="table-border text-tertiary-dark text-xs">
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    @if ($sale->paymentMethod->type == 'Otro')
                        {{ $sale->otherPaymentMethod ?? $sale->paymentMethod->type}}
                    @else
                        {{ $sale->paymentMethod->type ?? 'NA'}}
                    @endif
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($operation->amount) }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($sale->advance) }}
                </td>
                <td class="p-1 table-border font-light whitespace-no-wrap">
                    {{ formatAmount($operation->amount - $sale->advance) }}
                </td>
            </tr>
        </table>
    </div>


    @if($productPurchase)
        <div class="mt-4"></div>
        {{-- <div class="border-solid border-t-2 my-4 border-0 border-tertiary-light"></div> --}}
        <h3 class="font-bold">Productos</h3>
        <table class="w-full border-collapse table-fixed">
            <tr class="table-border">
                <td class="p-1 table-border text-center whitespace-no-wrap">Producto</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Precio</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Cantidad</td>
                <td class="p-1 table-border text-center whitespace-no-wrap">Total</td>
            </tr>
            @foreach($productPurchase->productPurchaseItems as $productPurchaseItem)
                <tr class="table-border text-tertiary-dark text-xs">
                    <td class="p-1 table-border font-light whitespace-no-wrap">
                        {{ $productPurchaseItem->name }} {{ $productPurchaseItem->isCancelled ? '(Cancelado)' : '' }}
                    </td>
                    <td class="p-1 table-border font-light whitespace-no-wrap">
                        {{ formatAmount($productPurchaseItem->price) }}
                    </td>
                    <td class="p-1 table-border font-light whitespace-no-wrap">
                        {{ $productPurchaseItem->quantity }}
                    </td>
                    <td class="p-1 table-border font-light whitespace-no-wrap">
                        {{ formatAmount($productPurchaseItem->total) }}
                    </td>
                </tr>
            @endforeach
            <tr class="table-border text-tertiary-dark text-xs">
                <td colspan="3"></td>
                <td class="p-1 table-border font-light whitespace-no-wrap">{{ formatAmount($productPurchase->total) }}</td>
            </tr>
        </table>
    @endif
</body>
</html>
