<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use PhpOffice\PhpSpreadsheet\Chart\Chart;
use PhpOffice\PhpSpreadsheet\Chart\DataSeries;
use PhpOffice\PhpSpreadsheet\Chart\DataSeriesValues;
use PhpOffice\PhpSpreadsheet\Chart\Layout;
use PhpOffice\PhpSpreadsheet\Chart\Legend as ChartLegend;
use PhpOffice\PhpSpreadsheet\Chart\PlotArea;
use PhpOffice\PhpSpreadsheet\Chart\Title;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Helper\Sample;

use App\Mail\RenewMembership;
use App\Mail\SetPassword;
use App\Mail\SuspendedAccount;
use App\Mail\Welcome;
use App\Models\Admin;
use App\Models\Studio;
use App\Models\User;
use Barryvdh\DomPDF\Facade as PDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\ValidationException;
use App\Custom\StripeErrorMessages;
use App\Models\Plan;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Stripe\StripeClient;
use Spatie\GoogleCalendar\Event;
use App\Custom\GoogleCalendarApi;
use App\Models\TattooArtist;
use Illuminate\Support\Facades\Validator;
use PulkitJalan\Google\Facades\Google;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function (Request $request) use ($router) {
    return "";
});
// $router->get('/', function (Request $request) use ($router) {
//     // $rules = [
//     //     // 'filesd.*.file' => 'required|mimes:png|max:100',
//     //     'competencies' => 'required|array|min:1',
//     //     'competencies.*' => 'required|numeric',
//     //     'endDate' => 'sometimes|date',
//     // ];
//     // $messages = [
//     //     'startDate.date' => 'Fecha de inicio incorrecta.',
//     //     'endDate.date' => 'Fecha de fin incorrecta.'
//     // ];

//     // $validator = Validator::make($request->all(), $rules, $messages);
//     // if ($validator->fails()) {
//     //     return response()->json([
//     //         'error' => $validator->errors()->first()
//     //     ], 400);
//     // }

//     // return $request->all();
//     // return $request->filesd[0]['file']->getClientOriginalName();
//     // return $router->app->version();
//     try {
//         $helper = new Sample();
//         $spreadsheet = new Spreadsheet();
//         $worksheet = $spreadsheet->getActiveSheet();
//         $worksheet->fromArray(
//             [
//                 ['', 2010, 2011, 2012],
//                 ['Q1', 12, 15, 21],
//                 ['Q2', 56, 73, 86],
//                 ['Q3', 52, 61, 69],
//                 ['Q4', 30, 32, 0],
//             ]
//         );

//         // Set the Labels for each data series we want to plot
//         //     Datatype
//         //     Cell reference for data
//         //     Format Code
//         //     Number of datapoints in series
//         //     Data values
//         //     Data Marker
//         $dataSeriesLabels = [
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$B$1', null, 1), // 2010
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$C$1', null, 1), // 2011
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$D$1', null, 1), // 2012
//         ];
//         // Set the X-Axis Labels
//         //     Datatype
//         //     Cell reference for data
//         //     Format Code
//         //     Number of datapoints in series
//         //     Data values
//         //     Data Marker
//         $xAxisTickValues = [
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_STRING, 'Worksheet!$A$2:$A$5', null, 4), // Q1 to Q4
//         ];
//         // Set the Data values for each data series we want to plot
//         //     Datatype
//         //     Cell reference for data
//         //     Format Code
//         //     Number of datapoints in series
//         //     Data values
//         //     Data Marker
//         $dataSeriesValues = [
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_NUMBER, 'Worksheet!$B$2:$B$5', null, 4),
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_NUMBER, 'Worksheet!$C$2:$C$5', null, 4),
//             new DataSeriesValues(DataSeriesValues::DATASERIES_TYPE_NUMBER, 'Worksheet!$D$2:$D$5', null, 4),
//         ];
//         $dataSeriesValues[2]->setLineWidth(60000);

//         // Build the dataseries
//         $series = new DataSeries(
//             DataSeries::TYPE_LINECHART, // plotType
//             DataSeries::GROUPING_STACKED, // plotGrouping
//             range(0, count($dataSeriesValues) - 1), // plotOrder
//             $dataSeriesLabels, // plotLabel
//             $xAxisTickValues, // plotCategory
//             $dataSeriesValues        // plotValues
//         );

//         // Set the series in the plot area
//         $plotArea = new PlotArea(null, [$series]);
//         // Set the chart legend
//         $legend = new ChartLegend(ChartLegend::POSITION_TOPRIGHT, null, false);

//         $title = new Title('Test Stacked Line Chart');
//         $yAxisLabel = new Title('Value ($k)');

//         // Create the chart
//         $chart = new Chart(
//             'chart1', // name
//             $title, // title
//             $legend, // legend
//             $plotArea, // plotArea
//             true, // plotVisibleOnly
//             DataSeries::EMPTY_AS_GAP, // displayBlanksAs
//             null, // xAxisLabel
//             $yAxisLabel  // yAxisLabel
//         );

//         // Set the position where the chart should appear in the worksheet
//         $chart->setTopLeftPosition('A7');
//         $chart->setBottomRightPosition('H20');

//         // Add the chart to the worksheet
//         $worksheet->addChart($chart);

//         // Save Excel 2007 file
//         $filename = $helper->getFilename(__FILE__);
//         $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
//         $writer->setIncludeCharts(true);
//         $callStartTime = microtime(true);
//         $writer->save($filename);
//         $helper->logWrite($writer, $filename, $callStartTime);
//         // $client = new GoogleCalendarApi();
//         // return dd(['authUrl' => $client->GetAuthUrl()]);
//         // return view('example');
//     } catch (\Throwable $e) {
//         return $e->getMessage();
//     }
// });

// $router->get('/authurl', function () use ($router) {
//     try {
//         // $client = Google::getClient();
//         // $calendar = Google::make('calendar');

//         // // $events = $calendar->events->get(
//         // //     '2022-04-12T00:00:00.0Z',
//         // //     '2022-04-12T23:00:00.0Z',
//         // // );

//         // return dd($calendar->events->get());

//         new Google_Client();
//         Google\Service\Calendar::CALENDAR;
//     } catch (\Throwable $e) {
//         return $e->getMessage();
//     }
//     try {
//         $client = new GoogleCalendarApi();
//         return $client->GetAuthUrl();
//     } catch (\Throwable $e) {
//         return $e->getMessage();
//     }
// });

// $router->get('/googleauth', function (Request $request) use ($router) {
//     // return dd($request->all());
//     try {
//         $client = new GoogleCalendarApi();
//         $data = $client->GetAccessToken(
//             env('GOOGLE_CLIENT_ID'),
//             env('GOOGLE_REDIRECT_URI'),
//             env('GOOGLE_CLIENT_SECRET'),
//             $request->code
//         );

//         if (!array_key_exists('access_token', $data))
//             return response()->json([
//                 'message' => 'No se pudo obtener el token de acceso'
//             ], 400);

//         Log::debug($data);

//         $access_token = $data['access_token'];
//         $user_timezone = $client->GetUserCalendarTimezone($access_token);

//         $free_busy = $client->FreeBusy(
//             $access_token,
//             '2022-04-12T00:00:00.0Z',
//             '2022-04-12T23:00:00.0Z',
//             $user_timezone,
//             'primary'
//         );

//         $calendars_list = $client->GetCalendarsList($access_token);

//         $google_event_id = $client->CreateCalendarEvent(
//             $access_token,
//             'primary',
//             [
//                 'summary' => 'Título del evento',
//                 'location' => 'Mi casa',
//                 'description' => 'Esta es la descripción completa de mi evento',
//             ],
//             0,
//             [
//                 'event_date' => '2022-04-12',
//                 'start_time' => '09:00:00',
//                 'end_time' => '10:00:00'
//             ],
//             $user_timezone
//         );

//         return dd([
//             'access_token' => $access_token,
//             'user_timezone' => $user_timezone,
//             'free_busy' => $free_busy,
//             'calendars_list' => $calendars_list,
//             'google_event_id' => $google_event_id
//         ]);
//     } catch (\Throwable $e) {
//         dd($e->getMessage());
//     }
// });

$router->post('/webhook', 'WebhookController@stripe');
// $router->post('/calendar-notifications', function (Request $request) use ($router) {
//     Log::debug($request->headers);
//     Log::debug($request->all());
// });

$router->group(['prefix' => 'guest'], function () use ($router) {
    $router->get('/sales/{id}/ticket', 'PDFController@saleTicket');
    $router->get('/tattooArtists/{id}', 'TattooArtistController@show');
    $router->get('/payrolls/{id}/pdf', 'PDFController@payrollPdf');
    $router->post('/stripe/subscribe/{id}', 'StripeController@createSubscription');
    $router->get('/stripe/test', 'StripeController@testApi');
    $router->get('/stripe/products', 'StripeController@getProducts');

    $router->post('/admins/', 'AdminController@store');
    $router->post('/admins/{id}/enable', 'AdminController@enable');

    $router->get('form-qr/{id}/{studio}', 'PDFController@formQr');
    $router->get('/forms/{id}', 'FormController@show');
    $router->post('/responses/', 'FormResponseController@store');
    $router->get('/forms/{id}/tattooArtistsAll', 'TattooArtistController@tattooArtistsAllGuest');
});

// Rutas de autenticación
$router->group(['prefix' => 'auth'], function () use ($router) {
    $router->post('/login', 'SessionController@login');
    $router->get('/users/{id}', 'UserController@show');
    $router->post('/sendRecoveryCode', 'SessionController@sendRecoveryCode');
    $router->post('/resetPassword', 'SessionController@resetPassword');

    $router->group(['middleware' => 'auth', 'prefix' => '/'], function () use ($router) {
        $router->post('/logout', 'SessionController@logout');
    });
});

// Rutas solo para super admin
$router->group(['middleware' => 'auth', 'prefix' => '/superAdminUser'], function () use ($router) {
    // CRUD de negocios
    $router->get('/businesses/', 'BusinessController@index');
    $router->get('/businesses/{id}', 'BusinessController@show');
    $router->post('/businesses/', 'BusinessController@store');
    $router->put('/businesses/{id}', 'BusinessController@update');
    $router->delete('/businesses/{id}', 'BusinessController@destroy');
    $router->get('/businesses/{id}/studios', 'BusinessStudioController@index');

    // Rutas para clientes
    $router->get('/admins/', 'SuperAdminAdminController@index');
    $router->get('/admins/{id}', 'SuperAdminAdminController@show');
    $router->put('/admins/{id}', 'SuperAdminAdminController@update');
    $router->post('/admins/{id}/disable', 'SuperAdminAdminController@disableClient');
    $router->post('/admins/{id}/enable', 'SuperAdminAdminController@enableClient');

    // Rutas para home
    $router->get('/plans/actives-inactives', 'PlanController@getActivesInactives');
    $router->get('/plans/by-type', 'PlanController@getPlansByType');
    $router->get('/plans/by-city', 'PlanController@getPlansByCity');
    $router->get('/plans/by-periodicity', 'PlanController@getPlansByPeriodicity');
    $router->post('/plans/excel', 'ExcelController@superAdminDashboardSpreadSheet');

    // Rutas para super admin
    $router->get('/superAdmins/', 'SuperAdminController@show');
    $router->put('/superAdmins/', 'SuperAdminController@update');
});

// Rutas solo para admin
$router->group(['middleware' => 'auth', 'prefix' => '/adminUser'], function () use ($router) {
    // Rutas para dashboard
    $router->get('/studios/{id}/dashboard', 'StudioController@dashboard');
    $router->post('/studios/{id}/dashboard-excel', 'ExcelController@dashboard');

    // CRUD de tatuadores
    $router->get('/tattooArtists', 'TattooArtistController@index');
    $router->get('/tattooArtistsAll', 'TattooArtistController@tattooArtistsAll');
    $router->get('/tattooArtists/{id}', 'TattooArtistController@show');
    $router->post('/tattooArtists', 'TattooArtistController@store');
    $router->put('/tattooArtists/{id}', 'TattooArtistController@update');
    $router->delete('/tattooArtists/{id}', 'TattooArtistController@destroy');

    // CRUD de sucursales
    $router->get('/studios/', 'StudioController@index');
    $router->get('/studios/{id}', 'StudioController@show');
    $router->post('/studios/', 'StudioController@store');
    $router->put('/studios/{id}', 'StudioController@update');
    $router->delete('/studios/{id}', 'StudioController@destroy');
    $router->get('/studios/{id}/tattooArtists', 'StudioTattooArtistController@index');
    $router->get('/studios/{studio}/tattooArtists/{tattooArtist}', 'StudioTattooArtistController@show');


    // Rutas para cortes
    $router->get('/payrolls/previews', 'PayrollController@previewIndex');
    $router->get('/tattooArtists/{id}/payrolls', 'TattooArtistPayrollController@index');
    $router->get('/payrolls/{id}', 'PayrollController@show');
    $router->post('/payrolls/', 'PayrollController@store');
    $router->delete('/payrolls/{id}', 'PayrollController@destroy');
    $router->post('/payrolls/excel', 'ExcelController@payrollSpreadSheet');
    $router->post('/payrolls/{id}/sendTicket', 'PayrollController@sendTicket');

    // Rutas para operaciones
    $router->get('/operations/', 'OperationController@index');
    $router->delete('/operations/{id}', 'OperationController@destroy');
    $router->put('/operations/{id}', 'OperationController@update');

    // Rutas para adelantos
    $router->get('tattooArtists/{id}/advancePayments/', 'TattooArtistAdvancePaymentController@index');
    $router->post('/advancePayments/', 'AdvancePaymentController@store');

    // Rutas para métodos de pago
    $router->get('/paymentMethods/', 'PaymentMethodController@index');

    // Rutas para mensajes de alerta
    $router->post('/hideAlert/', 'AdminController@hideAlert');

    // Rutas para cargos recurrentes
    $router->post('tattooArtists/{id}/recurringCharges', 'TattooArtistRecurringChargeController@store');
    $router->get('recurringCharges/paymentDate', 'RecurringChargeController@getNextPaymentDate');
    $router->delete('recurringCharges/{id}', 'TattooArtistRecurringChargeController@destroy');
    $router->get('tattooArtists/{id}/recurringCharges', 'TattooArtistRecurringChargeController@index');

    // Rutas para formularios
    $router->post('/forms/', 'FormController@store');
    $router->get('/forms/', 'FormController@index');
    $router->get('/responses/', 'FormResponseController@index');
    $router->delete('/form-responses/{id}', 'FormResponseController@destroy');
    // $router->get('/default-questions/', 'FormController@getDefaultQuestions');

    // Rutas para productos
    $router->get('/products', 'ProductController@getProductsForAdmin');
    $router->post('/products', 'ProductController@store');
    $router->post('/products/{id}', 'ProductController@update');
    $router->delete('/products/{id}', 'ProductController@destroy');
    $router->get('/productPurchases', 'ProductPurchaseController@index');
    $router->post('/productPurchases/excel', 'ExcelController@productPurchaseSpreadsheet');
    $router->post('/cancelProductPurchaseItem/{id}', 'ProductPurchaseItemController@cancelProductPurchaseItem');
});

// Rutas para admins sin suscripción
$router->group(['middleware' => 'auth', 'prefix' => '/unsubscribed/adminUser'], function () use ($router) {
    // Rutas para perfil de usuario admin
    $router->get('/businesses/', 'AdminBusinessController@show');
    $router->put('/businesses/', 'AdminBusinessController@update');
    $router->get('/admins/', 'AdminController@showAdminAsAdmin');
    $router->put('/admins/', 'AdminController@updateAdminAsAdmin');

    // Rutas para planes
    $router->get('/plansInfo/', 'PlanController@plansInfo');

    // Rutas para stripe
    // Rutas para métodos de pago
    $router->post('/createPaymentMethod/{id}', 'StripeController@createPaymentMethod');
    $router->get('/getPaymentMethods/{id}', 'StripeController@getPaymentMethods');
    $router->post('/setDefaultPaymentMethod/{id}', 'StripeController@setDefaultPaymentMethod');
    $router->delete('/removePaymentMethod', 'StripeController@removePaymentMethod');

    // Rutas para clientes
    $router->get('/getCustomer/{id}', 'StripeController@getCustomer');

    // Rutas para suscripciones
    $router->get('/getCustomerSubscription/{id}', 'StripeController@getCustomerSubscription');
    $router->delete('/cancelSubscription/{id}', 'StripeController@cancelSubscription');
    $router->put('/changePriceSubscription/{id}', 'StripeController@changePriceSubscription');
    $router->put('/cancelSubscriptionAtPeriodEnd/{id}', 'StripeController@cancelSubscriptionAtPeriodEnd');

    // Rutas para facturas
    $router->get('/getUpcomingInvoice/{id}', 'StripeController@getUpcomingInvoice');
});


// Rutas solo para tatuadores
$router->group(['middleware' => 'auth', 'prefix' => '/tattooArtistUser'], function () use ($router) {
    // Rutas para ventas
    $router->post('/sales/', 'SaleController@store');
    $router->post('/sales/{id}/sendTicket', 'SaleController@sendTicket');
    $router->get('/paymentMethods/', 'PaymentMethodController@index');
    $router->get('/tattooArtists/', 'TattooArtistController@tattooArtistsAsTattooArtist');
    $router->get('/businesses/', 'TattooArtistBusinessController@show');
    $router->get('/studios/', 'TattooArtistStudioController@show');
    $router->get('/todayFormResponses/', 'FormController@getTodayFormResponses');
    $router->delete('/formResponses/{id}', 'FormResponseController@destroyForTattoo');
    $router->get('/forms/', 'FormController@getformForTattoo');
    $router->post('/formResponses/{id}', 'FormResponseController@update');
    $router->put('/finishFormResponse/{id}', 'FormResponseController@finishFormResponse');

    // Rutas para productos
    $router->get('/products', 'ProductController@getProductsForTattoo');
    $router->post('/productPurchases', 'ProductPurchaseController@store');
});
